<?php
ob_start();
session_start();
include("config/config.php");
$site_name ="ELITE ENTERPRISES";
$logo = "img/elite-logo.png";
$favicon = "img/fms-logo.png";
$text_color = "color: black;";
if(isset($_SESSION['falcon'])) {
	header('location: home.php');
	exit;
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover, shrink-to-fit=no">
    <meta name="description" content="Suha - Multipurpose Ecommerce Mobile HTML Template">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#100DD1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <!-- The above tags *must* come first in the head, any other head content must come *after* these tags -->
    <!-- Title -->
    <title><?=$site_name?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet">
    <!-- Favicon -->
    <link rel="icon" href="<?=$favicon?>">
    <!-- Apple Touch Icon -->
    <link rel="apple-touch-icon" href="img/icons/icon-96x96.png">
    <link rel="apple-touch-icon" sizes="152x152" href="img/icons/icon-152x152.png">
    <link rel="apple-touch-icon" sizes="167x167" href="img/icons/icon-167x167.png">
    <link rel="apple-touch-icon" sizes="180x180" href="img/icons/icon-180x180.png">
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.css">
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/brands.min.css">
    <link rel="stylesheet" href="css/solid.min.css">
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <!-- Stylesheet -->
    <link rel="stylesheet" href="style.css">
    <!-- Web App Manifest -->
    <link rel="manifest" href="manifest.json">
  </head>
  <body>
    <!-- Preloader-->
    <!--<div class="preloader" id="preloader">
      <div class="spinner-grow text-secondary" role="status">
        <div class="sr-only"></div>
      </div>
    </div>-->
    <!-- Login Wrapper Area-->
    <div class="login-wrapper d-flex align-items-center justify-content-center text-center" style="background:linear-gradient(to left, #7c5d2a, #601e2ae0)">
      <!-- Background Shape-->
      <div class="background-shape"></div>
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-10 col-lg-8"><img class="big-logo" src="<?=$logo?>" alt="">
            <!-- Register Form-->
            <div class="register-form mt-5">
              <form >
                <div class="form-group text-start mb-4"><span>Mobile Number</span>
                  <label for="username"><i class="fa-solid fa-mobile"></i></label>
                  <input class="form-control" name="mobile" id="mobile" type="tel" placeholder="Mobile Number" required>
                  <span style="color:red" id="mobile_error"></span>
                </div>
                <div class="form-group text-start mb-4"><span>Password</span>
                  <label for="password"><i class="fa-solid fa-key"></i></label>
                  <input class="form-control" name="password" id="password" type="password" placeholder="Password" required>
                  <span style="color:red" id="password_error"></span>
                </div>
                <center><span id="success_msg" style="color:green;font-weight:900;"></span>
                <span id="error_msg" style="color:red;font-weight:900;"></span></center>
                <span class="btn btn-warning btn-lg w-100" id="login">Log In</span>
              </form>
            </div>
            <!-- Login Meta-->
            <div class="login-meta-data"><a class="forgot-password d-block mt-3 mb-1" href="forget-password.php">Forgot Password?</a>
              <!--<p class="mb-0">Didn't have an account?<a class="mx-1" href="https://firstmatrix.in.net/thirumalai-packers/public/login">Register Now</a></p>-->
            </div>
            <!-- View As Guest-->
            <!--<div class="view-as-guest mt-3"><a class="btn" href="home.php">View as Guest</a></div>-->
          </div>
        </div>
      </div>
    </div>
    <!-- All JavaScript Files-->
    <script src="js/bootstrap.bundle.min.js"></script>
    <script src="js/jquery.min.js"></script>
    <script src="js/waypoints.min.js"></script>
    <script src="js/jquery.easing.min.js"></script>
    <script src="js/jquery.magnific-popup.min.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script src="js/jquery.counterup.min.js"></script>
    <script src="js/jquery.countdown.min.js"></script>
    <script src="js/jquery.passwordstrength.js"></script>
    <script src="js/jquery.nice-select.min.js"></script>
    <script src="js/theme-switching.js"></script>
  <!--  <script src="js/active.js"></script>
    <script src="js/pwa.js"></script>-->
  </body>
  <style>
      .error{
          color:red;
      }
  </style>
  <script>
      $(document).ready(function(){
        $("#login").click(function(){
            var mobile = $('#mobile').val();
            var password = $('#password').val();
            if(mobile==''){
                $('#mobile_error').text('enter mobile number');
            }else if(password==''){
                $('#password_error').text('enter password');
            }else{
                  $.ajax({
                    url: "api/login.php",
                    type: "POST",
                    dataType:'json',
                    data: { mobile : mobile,password:password,type:'login' },
                    success: function(res){
                        if(res['error']){
                            $('#error_msg').text(res['message']);
                        }else{
                            $('#success_msg').text(res['message']);
                           window.location.href = 'home.php';
                        }
                        console.log('res'+res['error']);
                    }
                });   
            }
        });
        
        
        $("#mobile").on("keyup change", function(e) {
            $('#mobile_error').text('');$('#error_msg').text('');$('#success_msg').text('');
        });
        $("#password").on("keyup change", function(e) {
            $('#password_error').text('');$('#success_msg').text('');$('#error_msg').text('');
        });
        
      });
  </script>
</html>