<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover, shrink-to-fit=no">
    <meta name="description" content="Suha - Multipurpose Ecommerce Mobile HTML Template">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#100DD1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <!-- The above tags *must* come first in the head, any other head content must come *after* these tags -->
    <!-- Title -->
    <title>Suresh Packers and Movers</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet">
    <!-- Favicon -->
    <link rel="icon" href="icons/logo5.png">
    <!-- Apple Touch Icon -->
    <link rel="apple-touch-icon" href="img/icons/icon-96x96.png">
    <link rel="apple-touch-icon" sizes="152x152" href="img/icons/icon-152x152.png">
    <link rel="apple-touch-icon" sizes="167x167" href="img/icons/icon-167x167.png">
    <link rel="apple-touch-icon" sizes="180x180" href="img/icons/icon-180x180.png">
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.css">
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/brands.min.css">
    <link rel="stylesheet" href="css/solid.min.css">
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <!-- Stylesheet -->
    <link rel="stylesheet" href="style.css">
    <!-- Web App Manifest -->
    <link rel="manifest" href="manifest.json">
  </head>
  <body>
    <!-- Preloader-->
    <!--<div class="preloader" id="preloader">
      <div class="spinner-grow text-secondary" role="status">
        <div class="sr-only"></div>
      </div>
    </div>-->
    <!-- Login Wrapper Area-->
    <div class="login-wrapper d-flex align-items-center justify-content-center text-center" style="background:linear-gradient(to left, #7c5d2a, #601e2ae0)">
      <!-- Background Shape-->
      <div class="background-shape"></div>
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-10 col-lg-8"><img class="big-logo" src="icons/logo5.png" alt="">
            <!-- Register Form-->
            
            <div class="register-form mt-5">
              <form>
                <div class="form-group text-start mb-4"><span> Customer Name</span>
                    <label for="customer_name"><i class="fa-solid fa-user"></i></label>
                    <input class="form-control" name="customer_name" id="customer_name" type="text" placeholder="Enter Customer Name" required>
                    <span style="color:red" id="name_error"></span>
                </div>
                <div class="form-group text-start mb-4"><span>Email Id</span>
                    <label for="email"><i class="fa-solid fa-envelope"></i></label>
                    <input class="form-control" name="email" id="email" type="email" placeholder="Enter Email" required>
                    <span style="color:red" id="email_error"></span>
                </div>
                <div class="form-group text-start mb-4"><span>Mobile Number</span>
                    <label for="mobile"><i class="fa-solid fa-mobile"></i></label>
                    <input class="form-control" name="mobile" id="mobile" type="number" placeholder="Enter Mobile Number" required>
                    <span style="color:red" id="mobile_error"></span>
                </div>
                <div class="form-group text-start mb-4"><span>Password</span>
                    <label for="password"><i class="fa-solid fa-key"></i></label>
                    <input class="form-control" name="password" id="password" type="password" placeholder="Enter Password" required>
                    <span style="color:red" id="password_error"></span>
                </div>
                <div class="form-group text-start mb-4"><span>Address</span>
                    <label for="address"><i class="fa-solid fa-location-dot"></i></label>
                    <textarea class="form-control" name="address" id="address" type="text" placeholder="Enter Address" required></textarea>
                    <span style="color:red" id="address_error"></span>
                </div>
                
                <center><span id="success_msg" style="color:green;font-weight:900;"></span>
                <span id="error_msg" style="color:red;font-weight:900;"></span></center>
                <span class="btn btn-warning btn-lg w-100" id="register">Register</span>
              </form>
            </div>
            
            <!-- Login Meta-->
            <div class="login-meta-data">
              <p class="mt-3 mb-0">Already have an account?<a class="mx-1" href="login.php">Log In</a></p>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- All JavaScript Files-->
    <script src="js/bootstrap.bundle.min.js"></script>
    <script src="js/jquery.min.js"></script>
    <script src="js/waypoints.min.js"></script>
    <script src="js/jquery.easing.min.js"></script>
    <script src="js/jquery.magnific-popup.min.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script src="js/jquery.counterup.min.js"></script>
    <script src="js/jquery.countdown.min.js"></script>
    <script src="js/jquery.passwordstrength.js"></script>
    <script src="js/jquery.nice-select.min.js"></script>
    <script src="js/theme-switching.js"></script>
    <script src="js/active.js"></script>
    <script src="js/pwa.js"></script>
  </body>
  <style>
      .error{
          color:red;
      }
  </style>
  <script>
      $(document).ready(function(){
        $("#register").click(function(){
            reset();
            var name = $('#customer_name').val();
            var email = $('#email').val();
            var mobile = $('#mobile').val();
            var password = $('#password').val();
            var address = $('#address').val();
            if(name==''){
                $('#name_error').text('Enter Name');
            }else if(email==''){ 
                $('#email_error').text('Enter Email');
            }else if(mobile==''){
                $('#mobile_error').text('Enter Mobile');
            }else if(password==''){
                $('#password_error').text('Enter Password');
            }else if(address==''){
                $('#address_error').text('Enter Address');
            }else{
                console.log('Started');
                  $.ajax({
                    url: "api/register.php",
                    type: "POST",
                    dataType:'json',
                    data: { customer_name:name,email:email,mobile:mobile,password:password,address:address, type:'register' },
                    success: function(res){
                        console.log(res);
                        if(res['error']){
                            $('#error_msg').text(res['message']);
                        }else{
                            $('#success_msg').text(res['message']);
                            window.location.href = 'home.php';
                        }
                        console.log('res'+res['error']);
                    }
                });   
                
            }
        });
        
        
        $("#customer_name,#email,#mobile,#password,#address").on("keyup change", function(e) {
           reset();
        });
      
        function reset(){
            $('#name_error').text('');
            $('#email_error').text('');
            $('#mobile_error').text('');
            $('#apssword_error').text('');
            $('#address_error').text('');
            
            $('#success_msg').text('');
            $('#error_msg').text('');
        }
        
        
      });
  </script>
</html>