<?php  include "header.php"; ?>

<?php
if($_GET['id']){
    $product_id = $_GET['id'];
    
    $statement = $pdo->prepare("SELECT p.*, v.id as variant_id,
    v.image, v.purchase_product_tax_type, v.purchase_product_tax, v.purchase_product_amount, v.purchase_type, v.purchase_discount, 
    v.margin_percentage, v.purchase_price, v.selling_price, v.default_selling_price, v.product_tax_type, v.product_tax, v.hsn_code, v.sku,
    tbl_brand.name as brand_name, 
    tbl_category.name as category_name, tbl_sub_category.name as sub_category_name, tbl_size_category.name as size_category_name,
    tbl_brand.name as brand_name
    FROM `tbl_products` p 
    LEFT JOIN tbl_variations v ON v.product_id=p.id
    LEFT JOIN tbl_brand ON tbl_brand.id=p.brand
    LEFT JOIN tbl_category ON tbl_category.id=p.category 
    LEFT JOIN tbl_sub_category ON tbl_sub_category.id=p.sub_category 
    LEFT JOIN tbl_size_category ON tbl_size_category.id=p.size_category
    WHERE p.id=?");
    $statement->execute(array($product_id));
    $results = $statement->fetchAll(PDO::FETCH_ASSOC);
    $totalData = $statement->rowCount();
    
    $variant_id = $results[0]['variant_id'];
    $product_name = $results[0]['product_name'];
    $brand_name = $results[0]['brand_name'];
    $category_name = $results[0]['category_name'];
    $sub_category_name = $results[0]['sub_category_name'];
    $size_category_name = $results[0]['size_category_name'];
    $size_category = $results[0]['size_category'];
    
    
    $purchase_price = $results[0]['purchase_price'];
    $default_selling_price = $results[0]['default_selling_price'];
    
    if($size_category!=""){
        $cond=" and size_category_id=".$size_category;
    }else{
        $cond = "";
    }
    
}
?>

<div class="content-wrapper">
        <section class="content-header">
            <h1>Add Products <!--<span class='btn btn-primary btn-xs add_row_btn' ><i class='fa fa-plus'></i> Add Row</span>--></h1>
            <ol class="breadcrumb">
                <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Add Products </li>            
            </ol>
        </section>


        <div class="col-lg-12 alerts">
            <div id="custom-alerts" style="display:none;">
                <div class="alert alert-dismissable">
                    <div class="custom-msg"></div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>







<div id="content-div">
    
<form action="" id="add_form"  method="post" >
<section class="content">
    <div class="row">
        <div class="col-xs-12">
            
            
            <div class="box box-primary" style="box-shadow: rgba(0, 0, 0, 0.02) 0px 1px 3px 0px, rgba(27, 31, 35, 0.15) 0px 0px 0px 1px;">
                <div class="box-body">
                    <div class="col-lg-12">

                        <input type="hidden" name="product_id" id="product_id" value="<?=$product_id?>">
                        <input type="hidden" name="variant_id" id="variant_id" value="<?=$variant_id?>">
                        
                        
                        
                        <table style="width: 50%;">
                            <tr>
                                <th>Product Name:</th>
                                <th><?=$product_name?></th>
                            </tr>
                            <tr>
                                <th>Brand Name:</th>
                                <th><?=$brand_name?></th>
                            </tr>
                            <tr>
                                <th>Category Name:</th>
                                <th><?=$category_name?></th>
                            </tr>
                            <tr>
                                <th>Sub Category Name:</th>
                                <th><?=$product_name?></th>
                            </tr>
                            <tr>
                                <th>Size Category Name:</th>
                                <th><?=$size_category_name?></th>
                            </tr>
                            <tr>
                                <th>Purchase Price:</th>
                                <th><i class="fa fa-inr"></i> <?=number_format($purchase_price,2)?></th>
                            </tr>
                            <tr>
                                <th>Selling Price:</th>
                                <th><i class="fa fa-inr"></i> <?=number_format($default_selling_price,2)?></th>
                            </tr>
                        </table>
                        
                        
                        <span class='btn btn-primary btn-xs add_row_btn' style="margin-top: 10px;"><i class='fa fa-plus'></i> Add Row</span>

                        <br><br>
                        
                        <div id="products_sectionss">
                            
                        </div>
                        
                     

                    </div>
                    
                    
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="form-group" style="text-align:center;">
    <input type="submit" name="add_products" value="Add Products"  class="btn btn-success" />
</div>
</form>


<div class="form-group" style="text-align:center;">
        <a href="products-add.php"><button class="btn btn-primary" ><i class="fa fa-refresh"></i> Reset Form</button></a>
        <a href="products-list.php"><button class="btn btn-warning" ><i class="fa fa-chevron-left"></i> Back to List</button></a>
</div>

</div>

<br><br><br>

<div id="loading-div" style="display: none; padding-bottom: 80px;">
     <center> <img src="img/loading.gif" style="width: 250px;"><br><b class="blinking">Processing Please Wait...</b></center>
</div>

<div id="success-div" style="display: none; padding-bottom: 80px;">
     <center> <h3><b class="blinking">Product Added Successfully...</b></h3></center>
     <div class="form-group" style="text-align:center;">
        <a href="products-add.php"><button class="btn btn-primary" ><i class="fa fa-refresh"></i> Reset Form</button></a>
        <a href="products-list.php"><button class="btn btn-warning" ><i class="fa fa-chevron-left"></i> Back to List</button></a>
    </div>
</div>

    






<?php include "footer.php"; ?>


<!-- Products Add Section Starts Here -->
<script>
    $('#add_form').on('submit', function(e){
        console.log("Click And Form Working");
                e.preventDefault();
                $('#loading-div').show();
                $('#content-div').hide();
                var formData = new FormData(this);
                formData.append('type', 'new_products');
                            $.ajax({
                            url: 'apis/products.php',
                            type: 'post',
                            dataType: 'json',
                            data: formData,
                            cache: false,
                            contentType: false,
                            processData: false,
                            enctype: 'multipart/form-data',
                            success: function (response) {
                                if(response['status']==200){
                                     alert(response['message']);
                                     $('#loading-div').hide();
                                     $('#content-div').hide();
                                     $("#success-div").show();
                                }else{
                                    alert(response['message']);
                                    $('#loading-div').hide();
                                    $('#content-div').show();
                                }
                            }
                        });
    });
</script>
<!-- Products Add Section Endsss Here -->
<script>
    let count = 1;
    
    $(".add_row_btn").click(function(){
        
        
        var row = `<div class="row">
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="required" for="product_color">Product Color</label>        
                                        <select name="product_color[]" class="form-control tip select2" style="width: 100%;" id="product_color">
                                            <option value="">Select Color</option>
                                            <?php 
                                                $statement = $pdo->prepare("SELECT * FROM tbl_color WHERE status=1");
                                                $statement->execute();
                                                $results = $statement->fetchAll(PDO::FETCH_ASSOC); 
                                                foreach ($results as $result) { ?>
                                                  <option value="<?=$result['id']?>"><?=$result['name']?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            
                                <div class="col-md-3">
                                    <label>Product Size</label>
                                    <select name="product_size[]" class="form-control tip select2 product_size" id="" style="width: 100%;">
                                            <option value="">Select Size</option>
                                            <?php 
                                                $statement = $pdo->prepare("SELECT * FROM tbl_size WHERE status=1 $cond");
                                                $statement->execute();
                                                $results = $statement->fetchAll(PDO::FETCH_ASSOC); 
                                                foreach ($results as $result) { ?>
                                                  <option value="<?=$result['id']?>"><?=$result['name']?></option>
                                            <?php } ?>
                                    </select>
                                </div>
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="required" for="product_qty">Product Quantity</label>        
                                        <input type="text" name="product_quantity[]" class="form-control" id="" value="">
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="optional" for="product_notes">Box Details</label> 
                                        <input name="product_notes[]" class="form-control" style="width: 100%;" id="product_notes">
                                    </div>
                                </div>
                                
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <br>
                                        <span class='btn btn-danger remove_product_sections'><i class='fa fa-times'></i></span>
                                    </div>
                                </div>
                            
                            </div>`;
                            
                            
                            
        console.log(row);
        $("#products_sectionss").append(row);
        $(".select2").select2();
        console.log(row);
        get_sizes(count);
        count++;
    });
    
    
    function get_sizes(count){
        var size_category = $("#size_category").val();
        console.log(count);
        console.log(size_category);
            $('#product_size_'+count).empty(); 
            $.ajax({
                    url: 'api/get-values-api.php',
                    type: 'post',
                    dataType: 'json',
                    data: {type:'get_size_category',size_category:size_category},
                    success: function (response) {
                        console.log(response);
                        $('#product_size_'+count).empty(); 
                        
                        var m='<option value="">Select Size</option>';
                        if(response['error']==false){
                            for(var n=0;n<response['data'].length;n++){
                                m+='<option value='+response['data'][n]['id']+'>'+response['data'][n]['name']+'</option>';
                            }
                        }
                        
                        $('#product_size_'+count).append(m); 
                        $('#product_size_'+count).append(m).trigger("change");
                    }
            });
    }
    
    
    $(document).on('click', '.remove_product_sections', function() {
        $(this).closest('.row').remove();
    });
</script>

<style>
    th,td{
        padding: 5px;
    }
</style>
